import base64
import datetime
import json
import logging
import os

import redis
import sys

from snatcher import snatch_grading_work
development_mode = os.getenv('PYCHARM_HOSTED')

url_to_pause="https://etherpad.wendt.io/p/sdo-snatching/export/txt"

def main():
    log = logging.getLogger('wrapper')

    wait_n_messages_before_snatching = 0

    log.info("Running main")
    host = 'localhost' if development_mode else 'redis.wendt.vpn'
    try:
        client = redis.Redis(host=host, port=6379, decode_responses=True)
        pubsub = client.pubsub()
        pubsub.subscribe('email')
        log.info("Subscribed to 'email' topic")
        
        while True:
            now = datetime.datetime.now(datetime.timezone.utc).isoformat(sep=' ', timespec='seconds')
            log.info(f"Waiting for messages ({wait_n_messages_before_snatching}) at {now}")
            try:
                message = pubsub.get_message(ignore_subscribe_messages=True, timeout=60.0)
                if message:
                    log.info("Message received")
                    # Process message if received
                    if message['type'] == 'message':
                        payload = message['data']
                        if development_mode:
                            log.info(payload)
                        decoded_payload = base64.b64decode(payload)
                        data = json.loads(decoded_payload)
                        if "headers" in data:
                            if "subject" in data["headers"]:
                                subject = data["headers"]["subject"]
                                log.info(f"Subject: {subject}")
                                if "III Grading Required" in subject:
                                    log.info("Subject found - let's consider snatching!")
                                    if grading_on_pause():
                                        wait_n_messages_before_snatching =- 1
                                        log.info("Not snatching this one, on pause according to Etherpad")

                                    elif wait_n_messages_before_snatching <= 0:
                                        log.info("Yes, it's our time to shine - go go go!")
                                        if snatch_grading_work():
                                            log.info("Got new work, resetting wait to 4")
                                            wait_n_messages_before_snatching = 4
                                    else:
                                        wait_n_messages_before_snatching =- 1
                                        log.info(f"Not snatching this one, awaiting another {wait_n_messages_before_snatching} messages before snatching")
                                else:
                                    log.info("Ignoring this email")
            except Exception as e:
                log.error(f"Error processing message: {e}")
                sys.exit(1)
                
    except KeyboardInterrupt:
        log.info("Shutting down")
        sys.exit(0)
    except redis.RedisError as e:
        log.error(f"Redis connection error: {e}")
        sys.exit(1)
    except Exception as e:
        log.error(f"Unexpected error: {e}")
        sys.exit(1)

if __name__ == "__main__":
    logging.basicConfig(level=logging.INFO, stream=sys.stdout)
    main()
